unit Krok2;

interface

type
  TZamwienie = class
    function Warto: integer;
  end;

  TWeryfikacjaZamwienia = class
    procedure WeryfikujZamwienie(aZamwienie: TZamwienie);
  end;

  TRealizacjaZamwienia = class
  private
    FWeryfikacjaZamwienia: TWeryfikacjaZamwienia;
  public
    constructor Create(aWeryfikacjaZamwienia: TWeryfikacjaZamwienia);
    destructor Destroy; override;
    procedure RealizujZamwienie(aZamwienie: TZamwienie);
  end;

procedure RealizujZamwienia2;

implementation

uses
  System.SysUtils;

procedure RealizujZamwienia2;
var
  Zamwienie: TZamwienie;
  RealizacjaZamwienia: TRealizacjaZamwienia;
begin
  RealizacjaZamwienia := TRealizacjaZamwienia.Create(TWeryfikacjaZamwienia.Create);
  try
    Zamwienie := TZamwienie.Create;
    try
      RealizacjaZamwienia.RealizujZamwienie(Zamwienie);
    finally
      Zamwienie.Free;
    end;
  finally
    RealizacjaZamwienia.Free;
  end;
end;

function TZamwienie.Warto: integer;
begin
  Result := Random(1000) + 1
end;

{ TRealizacjaZamwienia }

constructor TRealizacjaZamwienia.Create(aWeryfikacjaZamwienia: TWeryfikacjaZamwienia);
begin
  inherited Create;
  FWeryfikacjaZamwienia := aWeryfikacjaZamwienia;
end;

destructor TRealizacjaZamwienia.Destroy;
begin
  FWeryfikacjaZamwienia.Free;
  inherited Destroy;
end;

procedure TRealizacjaZamwienia.RealizujZamwienie(aZamwienie: TZamwienie);
begin
  FWeryfikacjaZamwienia.WeryfikujZamwienie(aZamwienie);
end;

procedure TWeryfikacjaZamwienia.WeryfikujZamwienie(aZamwienie: TZamwienie);
begin
  WriteLn('Warto zamwienia: ' + IntToStr(aZamwienie.Warto));
end;

end.

